/* Erfragen des Resultats 
	liefert :
		[Tisch,Runde,Board,['N/S','O/W'],Teiler('N'),
		NS,OW,Spieler,
		Kontrakt : [3,'SA'/'Pik'/'Coeur'/'Karo'/'Treff',x/xx/' ']
		Ausspiel : [ 'Pik'/'Couer'/'Karo'/'Treff',
				'A' / 'K' / 'D' / 'B' / '10' / 'x'],
		Ist,Punkte]
	 oder : [Tisch,Runde,Board,['N/S','O/W'],Teiler('N'),
		NS,OW,'Passe',
		Kontrakt : [3,'SA'/'Pik'/'Coeur'/'Karo'/'Treff',x/xx/' ']
		Ausspiel : [ 'Pik'/'Couer'/'Karo'/'Treff',
				'A' / 'K' / 'D' / 'B' / '10' / 'x'],
		Ist,'Passe']   ... Kontrakt und Ausspiel und Ist bleiben Variablen
		*/

/* 3. Parameter liefert exist / close /ok */
get_res(Res,Res,exist) :-
	Res=[_Tisch,_Runde,_Board,_Gefahr,_Teiler,_NS,_OW,_Spieler,_Kontrakt,_Ausspiel,_Ist,_Punkte],
	clause(res(Res),true),!.
get_res(Res,Res1,Option) :-
	% Res=[Tisch,Runde,Board,Gefahr,Teiler,NS,OW,Spieler,Kontrakt,Ausspiel,Ist,Punkte],
	Res=[Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Punkte],
	prepare(NS,NSS),prepare(OW,OWW),
	% Res0=[Tisch,Runde,Board,Gefahr,Teiler,NSS,OWW,Spieler,Kontrakt,Ausspiel,Ist,Punkte],
	% Res1=[Tisch,Runde,Board,Gefahr,Teiler,NS,OW,Spieler1,Kontrakt1,Ausspiel1,Ist1,Punkte1],
	Res0=[Board,Runde,Tisch,Gefahr,Teiler,NSS,OWW,Punkte],
	Res1=[Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Punkte1],
	ask_gefahr(Board,Gefahr),
	ask_teiler(Board,Teiler),
	/*repeat,*/
	eb_f(Res0,[Punkte1],Option).

ask_gefahr(B,G) :- once(gefahr(B,G,_)),!.
ask_teiler(B,T) :- once(gefahr(B,_,T)),!.


% ----------------- BERECHNUNG -----------------

points(Res) :-
	Res=[_Tisch,_Runde,_Board,_Gefahr,_Teiler,_NS,_OW,'Passe',_Kontrakt,_Ausspiel,_Ist,0],!.
points(Res) :-
	Res=[_Tisch,_Runde,_Board,Gefahr,_Teiler,_NS,_OW,Spieler,Kontrakt,_Ausspiel,Ist,Points],
	Kontrakt=[Hoehe,Atout,Kontra],
	check_gefahr(Gefahr,Spieler,Gef),
	points1(Gef,Atout,Hoehe,Kontra,Ist,Points1),
	nsow(Spieler,F1),  % falls Spieler O oder W, dann multiplizieren mit -1.
	Points is Points1*F1.

points1(Gefahr,Atout,Hoehe,Kontra,Ist,Points) :-
	Ist >= 0,!,
	game_points(Atout,Hoehe,GP1),
	kontra_times_points(GP1,Kontra,GP),
	game_praemie(GP,Gefahr,GPr),
	ueberstiche(Kontra,Gefahr,Atout,Ist,Add),
	kontra_gewonnen(Kontra,KG),
	schlemm(Hoehe,Gefahr,Sch),
	Points is GP+GPr+Add+KG+Sch.
points1(no,_,_,' ',Ist,Points) :- !,Points is Ist*50.
points1(no,_,_,x,Ist,Points) :- Ist > -4,!,Points is Ist*200+100.
points1(no,_,_,x,Ist,Points) :- !,Points is (Ist+3)*300-500.
points1(no,_,_,xx,Ist,Points) :- Ist > -4,!,Points is Ist*400+200.
points1(no,_,_,xx,Ist,Points) :- !,Points is (Ist+3)*600-1000.
points1(yes,_,_,' ',Ist,Points) :- !,Points is Ist*100.
points1(yes,_,_,x,Ist,Points) :- !,Points is Ist*300+100.
points1(yes,_,_,xx,Ist,Points) :- Points is Ist*600+200.

game_points('SA',Hoehe,GP1) :- !,GP1 is Hoehe*30+10.
game_points(Atout,Hoehe,GP1) :- f(Atout,Punkte),GP1 is Hoehe*Punkte.

f('Pik',30) :- !.
f('Coeur',30) :- !.
f('Karo',20) :- !.
f('Treff',20) :- !.
f('SA',30).

kontra_times_points(GP1,K,GP2) :- kontr(K,F),GP2 is GP1 * F.

game_praemie(GP,_,50) :- GP < 100,!. 
game_praemie(_GP,yes,500) :- !.
game_praemie(_GP,no,300).

ueberstiche(_,_,_,0,0) :- !.
ueberstiche(' ',_,Atout,Ist,Add) :- !,f(Atout,V),Add is Ist * V.
ueberstiche(x,yes,_,Ist,Add) :- !,Add is Ist * 200.
ueberstiche(x,no,_,Ist,Add) :- !,Add is Ist * 100.
ueberstiche(xx,yes,_,Ist,Add) :- !,Add is Ist * 400.
ueberstiche(xx,no,_,Ist,Add) :- Add is Ist * 200.

schlemm(6,yes,750) :- !.
schlemm(6,no,500) :- !.
schlemm(7,yes,1500) :- !.
schlemm(7,no,1000) :- !.
schlemm(_,_,0).

kontra_gewonnen(' ',0) :- !.
kontra_gewonnen(x,50) :- !.
kontra_gewonnen(xx,100).

check_gefahr(Gefahr,Spieler,yes) :-
	el_gen(El,Gefahr),
	combine([El],X1),
	combine([Spieler],X2),
	substring(X2,X1),!.
check_gefahr(_,_,no).

kontr(' ',1) :- !.
kontr(x,2) :- !.
kontr(xx,4).

substring(S1,S2) :- atom_chars(S1,C1),atom_chars(S2,C2),subset2(C1,C2).
subset2([],_) :- !.
subset2([F|T],[F|T1]) :- subset1(T,T1).
subset2(T,[_|T1]) :- subset2(T,T1).

subset1([],_) :- !.
subset1([F|T],[F|T1]) :- subset1(T,T1).

% ---------------------- SORTIEREN Quicksort -------------------------

ssort([],[]) :- !.
ssort([E],[E]) :- !.
ssort(L,S) :- split1(L,L1,L2),
	ssort(L1,SL1),ssort(L2,SL2),
	merge1(SL1,SL2,S).

split1([],[],[]) :- !.
split1([E],[E],[]) :- !.
split1([E1,E2|Rest],[E1|R1],[E2|R2]) :- split1(Rest,R1,R2).

merge1(L,[],L) :- !.
merge1([F1|T1],[F2|T2],[F1|T3]) :- gt(F2,F1),!,merge1(T1,[F2|T2],T3).
merge1(L1,[F2|T2],[F2|T3]) :- merge1(L1,T2,T3).

% ALT: fuer Sortieren, wenn man die Punkte nicht auf NS umrechnet
% gt([P1,S1,_,_|_],[P2,S2,_,_|_]) :- !,nsow(S1,F1),nsow(S2,F2),P1*F1 < P2*F2.
% Sortieren nach dem Score, der auf Prozente korrigiert wurde
%  gt([alloc,proz(P1),_,_|_],[alloc,_,_,_|_]) :- !.
% Sortieren nach dem Score
gt([alloc,P1,_,_|_],[alloc,P2,_,_|_]) :- !,once((P1 =..[p|_];P1 < P2)).
% Sortieren der Resultatsliste nach dem 4. Par. : Prozente
gt([_,_,_,Proz1],[_,_,_,Proz2]) :- Proz1 < Proz2.
gt([_,S1],[_,S2]) :- once((S1 =..[p|_];  negativ((S2 =.. [p|_])),S1 < S2)).
%gt([_,S1,_],[_,S2,_]) :- S1 < S2.

nsow('N',1):-!.
nsow('S',1):-!.
nsow(_,-1).

/*
gt([X|_],[Y|_]) :- X > Y.
*/

show_res([Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Punkte]) :-
	show_res1([Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Punkte]),
	info(stream,nl,0),!.
show_res([Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Punkte],TPunkte,Prozente) :-
	show_res1([Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Punkte]),
	once((TPunkte=..[p|_],info(stream,' ',8)
	      ;
		generiere_zeile([TPunkte,' Pkt'],Points),
		info(stream,Points,8))),
	generiere_zeile([Prozente,' %'],Procent),
	info(stream,Procent,8),
	info(stream,nl,0),!.

show_res1([Board,Runde,Tisch,Gefahr,_Teiler,NS,OW,Punkte]) :-
	info(stream,Board,4),
	info(stream,Runde,6),
	info(stream,Tisch,6),
	info(stream,Gefahr,9),
	prepare(NS,NSS),prepare(OW,OWW),
	info(stream,NSS,9),info(stream,' /',2),info(stream,OWW,5),
/*	Kontrakt=[Number,Atout1,Kontra],Ausspiel=[Farbe1,Karte],
	trans(Atout,Atout1),trans(Farbe,Farbe1),
	info(stream,Number,5),info(stream,Atout,3),info(stream,Kontra,2),
	info(stream,Farbe,4),info(stream,Karte,2),info(stream,Ist,6),info(stream,Spieler,9),
*/
	once(((Punkte=p(_);Punkte=p(_,_);Punkte=p(_,_,_,_);
               Punkte=eins(_);Punkte=zwei(_);Punkte=drei(_);Punkte=vier(_)),
               Punkte1=Punkte
	      ;Punkte=n,Punkte1=n
	      ;Punkte1 is Punkte)),
	info(stream,Punkte1,16).

show_head(Stream) :- 
	info(Stream,'Board ',6),
	info(Stream,'Runde ',7),
	info(Stream,'Tisch ',6),
	info(Stream,'Gefahr   ',11),
	info(Stream,'NS-OW ',10),
/*	info(Stream,'Spiel ',12),info(Stream,'Ausspiel ',8),info(Stream,' Ist ',4),
	info(Stream,'Spieler ',10),*/
	info(Stream,'  Score ',19),
	info(Stream,nl,6),!.

trans(Var,Var) :- var(Var),!.   
trans('P','Pik') :- !.
trans('C','Coeur') :- !.
trans('K','Karo') :- !.
trans('T','Treff') :- !.
trans(X,X).


% ---------- Test ------
test :-
	member(Hoehe,[1,2,3,4,5,6,7]),
	member(Farbe,['Treff','Coeur','SA']),
	member(Ist,[0,1,2,3,4,5,6]),Hoehe+Ist<8,nl,
	write(Hoehe-Farbe-Ist-'  '),
	member(G,[no,yes]),
	member(Kontra,[' ','x','xx']),
	points1(G,Farbe,Hoehe,Kontra,Ist,M),
	write(M),write(' '),
	fail.
test.

