:- style_check(-singleton).
:- use_module(library(pce)).


%#!prolog
%:- dynamic boardres/3.
%:- dynamic personen/1.
%:- dynamic persons/1.
%:- dynamic boardsprorunde/1.
%:- dynamic form/1.
%:- dynamic result/1.
%:- dynamic rundenzahl/1.
%:- dynamic plusminus/4.
%:- dynamic boards/1.
%%:- dynamic runde/5.
%:- dynamic runden/1.
%:- dynamic turnier_info/1.
%:- dynamic res/1.
%:- dynamic beginn/2.
%:- dynamic spezi/3.
%:- dynamic geo/3.
%:- dynamic resulteinzel/2.
%:- dynamic drunde/5.
%:- dynamic tausche/3.

% Autor: JCl / Martin Behrndt
% Datum: 01.04.2004
% BridgeMenue

% --------------- STARTKONFIGURATION ---------------------------
source_dir('sources/').
quelldir('sources/').
systemdir('system/').
%call_name :- dos('C:\Programme\ULTRAEDT\UEDIT32.EXE namen.txt'),fail.
%call_name.

% --------------------------------------------------------------
% :- emacs('swibr.pl'). % Nur fuer die Entwicklung 

:- start_emacs.       % Module Emacs starten, sonst funktionieren die Emacsstyles nicht    
:- pce_autoload(finder, library(find_file)). % laden des Finder Modules
:- pce_global(@finder, new(finder)).   %erzeugen eines globalen Finders

reconsult(M) :- consult(M).

% ----------------- Menues --------------------------------
brmenu:-
	new(F, frame('Bridge Auswertung')),   % Frame erzeugen
	send(F, done_message, message(@prolog, beenden, f, F)),   
	% Aufrufen der Methode beenden beim Schliessen des Frames erzwingen
	send(F, append, new(DL, emacs_mode_dialog)),   % erzeugt ein Dialogelement im Emacsstyle (Keine Umrandung)
	send(DL, append, new(_L,label(help,'Protokoll',bold))), % fuegt einen Labeltext in DL ein
	send(new(DM, dialog),above,DL),    %erzeugt eine Standarddialog ueber DL
	  send(DM, append, new(MB, menu_bar)),   % fuegt eine Menueleiste in DM ein

% TEST
	%send(new(DM1, dialog),below,DM),    %erzeugt eine Standarddialog rechts neben DM
	  % send(DM1, append, button(quit,message(DM1,active,off))),   % Test fuegt eine Menueleiste in DM ein
	  % send(DM1, append, button(quit,message(DM1,visible,off))),   % Test fuegt eine Menueleiste in DM ein
	  % send(DM1, remove, button(quit,message(DM1,visible,off))),   % Test fuegt eine Menueleiste in DM ein
/*
emacs(File:Line) :-
	integer(Line),
	atom(File), !,
	start_emacs,
	send(@emacs, goto_source_location, source_location(File, Line)).
emacs(File) :-
	start_emacs,
	send(@emacs, goto_source_location, source_location(File)).

%	emacs_toplevel
%	
%	Propare to run PceEmacs as a stand-alone executable.
emacs_toplevel :-
	send(@pce, trap_errors, @off),
	current_prolog_flag(argv, Argv),
	files(Argv, Files),
	(   Files = [_|_]
	->  start_emacs,
	    maplist(make_buffer, Files, [B0|_]),
	    send(B0, open)
	;   emacs
	).

make_buffer(File, Buffer) :-
	new(Buffer, emacs_buffer(File)).

files(List, Files) :- append(_, ['--'|Files], List), !.
files(List, Files) :- append(_, ['-x', _State|Files], List), !.
files([_Prog|Files], Files).
*/

	send_list(MB, append, [new(Dat, popup(datei)),        % fuegt Popupbuttons in MB ein
                               new(Turnier, popup(turnierdaten)),
                               % new(Edit, popup(editieren)),
			       new(Vollst, popup('Vollstaendigkeit')),
			       new(Result, popup(resultate)),
			       new(Hilfe, popup(hilfe)),
			       new(Profi, popup(system))
			       %,
			       %new(Button, button(haha))
			       ]),
	
	send_list(Dat, append, [menu_item(laden, message(@prolog, laden)), 
	% fuegt Menuepunkte in den Popupbutton ein und definiert die auszufuehrende Aktion 
	% beim Anklicken (@prolog arbeitet ein Prologpraedikat ab)
				menu_item(speichern, message(@prolog, speichern)),
%				menu_item(saveConfig, message(@prolog, saveconfig)),
				menu_item(beenden, message(@prolog, beenden, f, F))]),
	
        send_list(Turnier, append, [
		menu_item('Turnierform', message(@prolog, editturnierform)),
		menu_item('Spieler eingeben', message(@prolog, editspieler)),
		menu_item('Runden/Boards waehlen', message(@prolog, turnierdaten1)),
		menu_item('Resultate eingeben', message(@prolog, eingabe)),
        % wieder raus  menu_item('Resultatsdatei laden', message(@prolog, resultladen)),
        	menu_item(laufkarten, message(@prolog, laufkarten)),
		menu_item('** Spieler editieren (Rest bleibt)', message(@prolog, editspieler2)),
%		menu_item('** Spieler editieren (Rest bleibt)',
%                      and(message(@prolog, editspieler2),message(@prolog,editspieler2a))),
		menu_item(reset, message(@prolog, myreset))
				   ]),
	
%	send_list(Edit, append, []),
	
	send_list(Vollst, append, [
		menu_item('Test_complete', message(@prolog, complete)),
		menu_item('Resultate Plausibel?', message(@prolog, plausibel))
		]),
	
        send_list(Result, append, [
%        	menu_item('nach Boards sortiert', message(@display, inform, 'nach Boards sortiert')),
%		menu_item('nach Runden sortiert', message(@display, inform, 'nach Runden sortiert')),
%		menu_item('nach Spieler sortiert', message(@display, inform, 'nach Spieler sortiert')),
%		menu_item('pro Board', message(@display, inform, 'pro Board')),
		menu_item('Gesamt', message(@prolog, endresult)),
		menu_item('GesamtLatex', message(@prolog, endresultlatex)),
%		menu_item('Strafen', message(@prolog, strafen)),
		menu_item('Zwischenstand', message(@prolog, teilresultat))
%		menu_item('Gesamt in Datei', message(@display, inform, 'Gesamt in Datei'))
		]),
	
	send_list(Hilfe, append, [
		menu_item(hilfe, message(@prolog, hilfe)),
		menu_item(about, message(@prolog, about))
		]),

        send_list(Profi, append, [
		menu_item('Movements testen', message(@prolog, allesda)),
		menu_item('Mischrunden', message(@prolog, mischrunden)),
		menu_item('Tische platzieren', message(@prolog, tischeplatzieren)),
		menu_item('Boards wann fertig?', message(@prolog, boardsfertig)),
		menu_item('Boards erstes Mal?', message(@prolog, boardsfirst)),
		menu_item('Wer spielt Boards nicht?', message(@prolog, boardsnicht))
		]),
	
	send(new(BP, browser), below, DL),	%fuegt ein Browserobject unter DL in F ein
	send(BP, style, code, style(font := font(courier, bold, 14))),

	send(new(DT, emacs_mode_dialog), below, BP), 
	% fuegt Dialog fuer das Textfeld ein, das muss sein, weil der gap-Befehl 
	% in DI sonst das Textfeld als Referenz nutzt und die 2. Spalte an ihm ausrichtet

	send(DT, append, new(TI, text_item('aktuelle Datei'))),
	send(DT, gap,size(50,5)), % deshalb dynamische Anpassung bei resize !!
	send(TI, editable, @off),

	send(new(DI, dialog), below, BP), % Dialog fuer die Auswahlkriterien
	 % definiert den Abstand zum naechsten Dialog_item in X und Y Richtung 
	send(DI, gap,size(25,10)),
    % send(DI, append, new(TF, menu('Art des Turniers',cycle))),  
    % fuegt zu DI ein Dialog_item vom Typ menue hinzu
    % send(DI, append, new(ASp, menu('Anzahl der Spieler/Paare',cycle))), % der Menuetyp ist cycle (Kombinationsfeld)
	send(DI, append, new(TT, text_item('Turnierform'))),
	send(DI, gap,size(50,5)), % deshalb dynamische Anpassung bei resize !!
	send(TT, editable, @off),
	send(DI, append, new(ASp, text_item('Anzahl der Spieler/Paare'))),
	send(ASp, editable, @off),
/*
	send(DI, append, new(AR, menu('Anzahl der Runden',cycle))),
	send(DI, append, new(BpR, menu('Boards pro Runde',cycle))),
*/
	send(DI, append, new(AR, text_item('Anzahl der Runden'))),
	send(AR, editable, @off),
	send(DI, append, new(BpR, text_item('Boards pro Runde'))),
	send(BpR, editable, @off),
/*	send(DI, append, new(AP, menu('Anzahl der Paare', cycle))), % die naechsten 3 Zeilen zeigen.wie man ein
	send(AP, auto_align, off),                                  % Dialogobject an einem festen Punkt einfuegt
	send(DI, display, AP,point(250,60)),
	send(new(AP, menu('Anzahl der Paare', cycle)),right,ASp),   
	% solange gap richtig funktioniert ist dies aber die besser Variante,
	% um Menuepunkte nebeneinander zu setzen
*/
%	send_list(TF, append, [paar, individual]),     % fuellt das Kombinationsfeld TF 
	% send_list(AP, append, [1,2]),
	% send_list(BpR, append, [2,3,4,5,6]),
%	send(TT,append, '       '),
%	send(TI, editable, @off),

	send(F, open),   % oeffnet den Frame F, ab jetzt ist er sichtbar

	d_speichern(f,F),    % legt Clause mit dem Zeiger auf den Frame an
	d_speichern(dl,DL),
	d_speichern(bp,BP),
	d_speichern(ti,TI),	resize_TI(TI),
	d_speichern(asp,ASp),
	d_speichern(tt,TT), resize_feld(tt,180),
	d_speichern(ar,AR),
	d_speichern(bpr,BpR),
	send(F,height,500),
	send(F,width,700),
	ask_geom(f,F,geometry).

% ---- Verwalten der Pointer auf Frame / Dialog etc.
d_speichern(O,Adresse) :- Call =.. [O,_],Call1 =.. [O,Adresse], einmal(Call),assert(Call1).

% ---- Verwalten der Geometrie der Objekte -------------------
% Typ: geometry oder position
set_geom(Name,Window,Typ) :- 
	get(Window,Typ,Neu),
	einmal(geo(Name,_,_)),
	assert(geo(Name,Typ,Neu)),!.
ask_geom(Name,Window,Typ) :-
	clause(geo(Name,Typ,Alt),_),!,
	send(Window,Typ,Alt).
ask_geom(_,_,_).

% -------------- Unteraufgaben -----------------------
% ------------------- Beenden ------------------------
% Name .. logischer Name, Objekt .. Adresse des Objekts
beenden(Name,Objekt):-
	set_geom(Name,Objekt,geometry),
	get(Objekt, area, FArea),       % holt sich die Koordinaten des Frames
	get(FArea, center, Point), % bestimmt den Mittelpunkt des Frames
	new(FE, frame('Programm Beenden')),  % erzeugt einen Dialogframe
	send(FE,append, new(DE, dialog('Programm Beenden'))),
	send_list(DE, append, [
		label(help,'Wollen Sie das Programm wirklich beenden ?'),
		button(ja, and(message(Objekt, destroy),    % schliesst Ausgangsframe
			message(@prolog,saveconfig),
			message(DE, destroy), % schliesst Dialogframe
			message(@prolog,schlussspeichern),
			message(@prolog,halt)
				    )),
		     button(nein, message(DE, destroy))
		     ]),
	send(FE, open_centered(Point,true)). 
		% oeffnet den Dialogframe zentriert auf dem Mittelpunkt des Ausgangsframes

% -------------------- LADEN / SPEICHERN -------------
schlussspeichern :-
	date(date(J,M,D)),
	generiere_zeile([temp,'/',temp,J,M,D,'.pl'],Datei),
	speichern(Datei).

speichern :- 
    resultladen,
% NEU	
    get(@finder, file, @off,'.pl', File1),
    File=File1,
	%    write(FileName),nl,
%ALT
%	ask_window('Auf welche Datei wollen Sie speichern ?', File1),
	%	get(@finder, file, @on, '.pl', File),
	% combine([File1,'.pl'],File),
    speichern(File),
    combine(['cat ',File],Comm),shell(Comm),
    !.

speichern(File) :-
	tell(File),current_output(CC),
%	write(':-dynamic persons/1,personen/1,form/1,turnier_info/1,res/1,boardres/3,result/1.'),nl,
%	write(':-dynamic rundenzahl/1,boardsprorunde/1.'),nl,
%%	write(':-dynamic runde/5,boards/1,rundenzahl/1,runden/1,boardsprorunde/1.'),nl,
%	write(':-dynamic plusminus/4.'),nl,nl,
	listing(form/1),
	listing(turnier_info/1),
	listing(persons/1),
	listing(personen/1),
	listing(boards/1),
	listing(boardsprorunde/1),
	listing(rundenzahl/1),
	listing(runden/1),
        write('% Tisch-Runde-NS-OW-Boards'),nl,
	listing(runde/5),
        write('% Board-Runde-Tisch-Gefahr-Teiler-NS-OW-Res'),nl,
	listing(res/1),
	listing(plusminus/4),
	listing(boardres/3),
	listing(resulteinzel/2),
	listing(result/1),
    once((clause(strafe(_,_),_),listing(strafe/2);true)),
	close(CC),told,
	message(['Datei gespeichert ']).
	
% tbd: Wie speichert man die anderen Windows ??
% Windows-Konfiguration speichern
saveconfig :- 
	loesche_datei('brinit.pl'),
	tell('brinit.pl'),
	write(':-dynamic geo/3.'),nl,nl,
	write('% geo(Objekt,Typ,Geometry).'),nl,nl,
	listing(geo/3),
	told,
	% message(['Konfiguration gespeichert']).
	true.
laden:-
	reset_result,
	reset_basics,
	get(@finder, file, @on, '.pl', FileName),
	  % erzeugt einen Dateibrowser, im Filemodus, oeffnen, von pl Datein, 
	  % mit der Rueckgabe des gewaehlten Dateinamen
        einmal(akt_dat(_)), assert(akt_dat(FileName)),
	    	ti(TI),set_feld(TI,FileName),
               consult(FileName),
	erzeuge_result_files,  % result.pl muss geschrieben werden, da sonst auf result.pl noch 
			       % alte Daten stehen
	set_data,!.
%	deaktiviere.

set_data:- bpr(BPR),asp(A),tt(TT),ar(AR),
	    (clause(boardsprorunde(BpR),_),set_feld(BPR,BpR);set_feld(BPR,'')),
	    (clause(persons(Persons),_),set_feld(A,Persons);set_feld(A,'')),
	    (clause(form(Form),_),set_feld(TT,Form);set_feld(TT,'')),
	    (clause(rundenzahl(Runden),_),set_feld(AR,Runden);set_feld(AR,'')),
	!.

% ------------------------ Reset -------------------
%reset:-
%	    einmal(akt_dat(_)), set_TI(''),
%	    aktiviere.

% ----------------- Hilfsfunktionen fuer Windows und Felder ----
resize_feld(TI,Width):-  % passt die Groesse des Textfeldes an
	Call =.. [TI,TI1],
	Call,% write(ti1-TI1),nl,
	% get(F, size,Fsize),
	% get(Fsize,width,Fwidth),
	% write(width-Fwidth),nl,
	% Width is Fwidth - 160,
	send(TI1, value_width,Width).

resize_TI(TI):-  % passt die Groesse des Textfeldes an
	                ti(TI),f(F),
	                get(F, size,Fsize),
			get(Fsize,width,Fwidth),
			Width is Fwidth - 160,
			send(TI, value_width,Width).

set_TI(Text):-   % schreibt Text ins Textfeld
	                resize_TI(TI),
	                send(TI,clear),
			send(TI,append,Text).

set_feld(Feld,Text):-   % schreibt Text ins Textfeld
	                %resize_feld(Feld,50),
			send(Feld,clear),
			send(Feld,append,Text).

aktiviere :-      % aktiviert Menue_items
                        tt(TT),bpr(BpR),                        
			send(TT, active, @on),
			send(BpR, active, @on). 
deaktiviere:-    % deaktiviert Menue_items
                        bpr(BpR),ti(TI),asp(ASp),tt(TT),ar(AR),
			send(BpR, active, @off),
			send(TI, active, @off),
			send(ASp, active, @off),
			send(TT, active, @off),
			send(AR, active, @off).

deaktiviere_menu_eingabe:-    % deaktiviert Menue_items
                        bpr(BpR),ti(TI),asp(ASp),tt(TT),ar(AR),
			send(BpR, active, @off),
			send(TI, active, @off),
			send(ASp, active, @off),
			send(TT, active, @off),
			send(AR, active, @off).

leere(Stream) :- Call=..[Stream,Adresse],clause(Call,_),Call,
	send(Adresse,clear),!.
leere(_Stream).
% ---------------- Hilfspraedikate ---------------

einmal(X):- once(retractall(X)).

/*hilfe:-	      send(@display, inform, 'Bei den ganzen Zusatzdateien kann man hier auch eine
Hilfe.txt einbinden.').
*/
hilfe:-     % oeffnet die Hilfe.txt zentriert ueber dem Frame
             f(F),   
	     get(F, area, FArea),
	     get(FArea, center, Point),
	     new(FV, frame('Hilfe')),
	     send(FV, append, new(V, view)),
	     send(V, load, 'hilfe.txt'),

	     send(FV, open_centered(Point,true)).	    

about:-       send(@display, inform, 'Brigde Auswertung: by Juergen Cleve').

% ----------- Standard-Windows -----------------------
msg_window(Text) :- send(@display, inform, Text).

/*
test(Element) :-
	new(F, frame('Hallo')),   % Frame erzeugen
	% send(F, done_message, message(@prolog, beenden, f, F)),   
	% Aufrufen der Methode beenden beim Schliessen des Frames erzwingen
	send(F, append, new(DE, dialog(''))),  % erzeugt einen Dialogframe
	send(DE, append, label(help,hallo)),
	mess_window_list(DE,[1,2,3]),
	(clause(geo(spass,position,Alt),_),send(F,position,Alt);true),
	get(DE,confirm,Element1),write(go),nl,
	get(F,area,Neu),write(Neu),nl,show_slots(F),
	einmal(geo(spass,_,_)),
	assert(geo(spass,position,Neu)),
	free(F),
	Element=Element1.
*/

mess_window(Text,Auswahl,Element) :-
	new(DE, dialog('')),  % erzeugt einen Dialogframe
	send(DE, append, label(help,Text)),
	% send(DE, append, new(_TI, text_item(name))),
	mess_window_list(DE,Auswahl),
	% ask_geom(mess,DE,position),
	get(DE,confirm_centered,Element1),
	% set_geom(mess,DE,position),
	free(DE),
	Element=Element1.

mess_window_list(_DE,[]) :- !.
mess_window_list(DE,[Atom|Liste]) :-
	send(DE, append, 
		button(Atom, message(DE,return,Atom))),
	mess_window_list(DE,Liste).
	

menu_window2(Text, Auswahl, _Element) :-
	new(F, frame('')),   % Frame erzeugen
	%send(F, done_message, message(DE, destroy))destroy
	% erzeugt ein Dialogelement im Emacsstyle (Keine Umrandung)
	send(F, append, new(DL, emacs_mode_dialog)),   
	send(new(DM, dialog),above,DL),    %erzeugt eine Standarddialog ueber DL
	% send(F, new(DM, dialog)),
	send(DM, append, new(TI, menu(Text,cycle))),  % fuegt zu DI ein dialog_item vom Typ menue hinzu
	send_list(TI, append, Auswahl),
	% bei Ok wird der aktuelle Wert  zurueckgegeben, der in TI steht
	send(F, open).   % oeffnet den Frame F, ab jetzt ist er sichtbar

menu_window(Text, Auswahl, Pred) :-
	new(DE, dialog(Text)),  % erzeugt einen Dialogframe
	% send(FE,append, new(DE, dialog(Text))),
	send(DE, append, label(help,Text)),
%	send(DE, append, new(TI, text_item(name))),
	send(DE, append, new(TI, menu('Auswahl',cycle))),
		send_list(TI, append, Auswahl),
	send(DE, append, 
		button(ok, message(DE,return,TI?selection))),
	send(DE,default_button,ok),
	% ask_geom(menu,DE,position),
	get(DE,confirm,Pred1),
	% set_geom(menu,DE,position),
	free(DE),
	Pred=Pred1.

ask_window(Text,Eingabe) :-
	new(DE, dialog(Text)),  % erzeugt einen Dialogframe
	send(DE, append, label(help,Text)),
	send(DE, append, new(TI, text_item(eingabe))),
	send(DE, append, 
		button(ok, message(DE,return,TI?selection))),
	send(DE,default_button,ok),
	% ask_geom(ask,DE,position),
	get(DE,confirm,E1),write(go),nl,
	% set_geom(ask,DE,position),
	free(DE),
	Eingabe=E1.
	
jn_window(Text,Answer) :- mess_window(Text,[ja,nein],Answer),!.

% -------------- Systemabhaengige Praedikate ---------------- 
all(Call,X,_Sol,Praedikat) :- CC=..[Praedikat,_],kill(CC),
	C1=..[Praedikat,[]],assert(C1),
	call(Call),
	C2=..[Praedikat,L],retract_once(Praedikat/1,C2),
	C3=..[Praedikat,[X|L]],assert(C3),
	fail.
all(_,_,Sol,P) :- C=..[P,Sol],retract_once(P/1,C).

add_clause(_P,C) :- clause(C,true),!.
add_clause(_P,C) :- assert(C).

kill(M) :- retractall(M).
retract_once(_P,C) :- clause(C,_),retract(C),!.
% once(P) :- P,!.

lade(File) :- string(File),!,atom_string(A,File),reconsult(A).
lade(File) :- reconsult(File).

exists(C) :- negativ(C),!,fail.      exists(_C).
negativ(C) :- C,!,fail.              negativ(_C).

maxi(A,B,A) :- A>B,!.                maxi(_A,B,B).

% --------------------- AUSGABE-Praedikate -----------------------
%set_window :- kill(ausgabe_state(_)),assert(ausgabe_state(window)),!.
%set_datei(Datei) :- kill(ausgabe_state(_)),assert(ausgabe_state(datei(Datei))),!.

frage(Liste,Answer) :- combine(Liste,String),jn_window(String,Answer).

info(stream,Text,Tab) :- !,info_window(stream,Text,Tab).
info(_,Text,Tab) :- !,info_window(bp,Text,Tab).

info_window(stream,nl,_Tab) :- nl,!.
info_window(stream,Text,Tab) :- ausgabe_tab(stream,Text,Tab),!.
info_window(_Window,nl,_Tab) :- !. %,neueZeile(Window).
info_window(_Window,Text,Tab) :- ausgabe_tab(bp,Text,Tab),!.

generiere_zeile([],'') :- !.
generiere_zeile([[Text,Laenge]|Rest],Ausgabe) :- !,
	combine(Text,A1),
	atom_chars(A1,Liste),length(Liste,N),
	erweitere(A1,Laenge,N,A2),
	generiere_zeile(Rest,Ausgabe2),
	combine([A2,Ausgabe2],Ausgabe).
generiere_zeile([Text|Rest],Ausgabe) :-
	combine(Text,A1),
	generiere_zeile(Rest,Ausgabe2),
	combine([A1,Ausgabe2],Ausgabe).

erweitere(Atom,LaengenVorgabe,Laenge,Atom) :- Laenge >= LaengenVorgabe,!.
erweitere(Atom,LaengenVorgabe,Laenge,Atom1) :-
	Diff is LaengenVorgabe-Laenge,ergaenze(Diff,Tab),
	combine([Tab,Atom],Atom1).

erzeuge_listenzeichen([X],[X,']']) :- !.
erzeuge_listenzeichen([F|R],[F,','|R1]) :- erzeuge_listenzeichen(R,R1).

ausgabe_tab(Window,[First|Rest],Tab) :- !,
	erzeuge_listenzeichen([First|Rest],Liste),
	%write(Liste),nl,
	generiere_zeile(['['|Liste],Liste2),
	%write(Liste2),nl,
	ausgabe_tab(Window,Liste2,Tab).
ausgabe_tab(Window,Texte,Tab) :-
	combine(Texte,String1),
	atom_chars(String1,Liste),length(Liste,N),
	(Tab==no,Diff=0;Tab\==no,Diff is Tab -N),
	ergaenze(Diff,String2),
	combine([String2,String1],String),
	schreibe(Window,String).
ergaenze(0,'') :- !.
ergaenze(1,' ') :- !.
ergaenze(2,'  ') :- !.
ergaenze(3,'   ') :- !.
ergaenze(4,'    ') :- !.
ergaenze(5,'     ') :- !.
ergaenze(N,String) :- 
	N > 5,!,N1 is N-5,
	ergaenze(N1,String1),combine(['     ',String1],String).
ergaenze(_,'').

/* akzeptiert eine Liste von Strings und gibt nil oder einen String zurueck */
get_input(Texte,Eingabe) :- combine(Texte,String),input_window(String,Eingabe).
/* gibt eine Meldung aus */

message(Liste) :- combine(Liste,Atom),msg_window(Atom).

combine([],'') :- !.
combine([F|T],Atom) :- !,check_atom(F,F1),combine(T,S1),atom_concat(F1,S1,Atom).
combine(F,Atom) :- check_atom(F,Atom).

check_atom(A,A) :- atom(A),!.
check_atom(A,S) :- number(A),!,number_chars(A,List),atom_chars(S,List).
%check_atom(S,S) :- string(S),!.
check_atom(Term,S) :- Term =.. [F|Liste],transterm(Liste,L1),combine([F,'('|L1],S).

transterm([F],[F,')']) :- !.
transterm([F|Rest],[F,','|R1]) :- transterm(Rest,R1).

% schreibt ein Atom 
schreibe(stream,nl):- nl,!.
schreibe(stream,A1):- combine([A1],A),	write(A),!.
schreibe(Window,A1):- combine([A1],A),	C=..[Window,BP], C,send(BP,append,A),!.

% ------------------------------------------------------------------

% once(X) :- one(X).

reset_datei(F) :- loesche_datei(F),
	telling(Tell),
	(tell(F) ; nl,told,tell(Tell),fail),
	current_output(Stream),
	(true;close(Stream),fail),
	write('% leer'),nl,
	fail.
reset_datei(_).
	
loesche_datei(File) :- exists_file(File), % Datei existiert ?
	delete_file(File),!.
loesche_datei(_File).

% Initialisieren
sys_laden(Datei) :-
	combine([Datei,'.pl'],Name), % Dateinamen bilden
	exists_file(Name), % Datei existiert ?
	consult(Datei),!.
sys_laden(Datei) :- systemdir(Sys),
	combine([Sys,Datei,'.pl'],Name), % Dateinamen bilden
	exists_file(Name), % Datei existiert ?
	consult(Name),!.
sys_laden(Datei) :-
	message([Datei,' ','existiert nicht !']).

:- sys_laden(brutil).
:- sys_laden(brmain).
:- sys_laden(brcandi).
:- sys_laden(brgefahr).
:- sys_laden(brmain).
:- sys_laden(brinit).
:- sys_laden(brlatex).
%:- dynamisch,leer_turnier. % JCl
:- write('LOS GEHTS'),nl.

:- brmenu.
